<div class="tab-pane fade  {{$route == 'web-payment'?'show active':''}}" id="web-payment" role="tabpanel"
    aria-labelledby="web-payment-tab">
    <div class="row">
        <div class="col-md-6 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h4>@lang('payment.stripe.credentials')</h4>
                </div>
                <div class="card-body">
                    <form action="{{route('admin.settings.payment.stripe')}}" method="POST">
                        @csrf
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="name">@lang('payment.stripe.status')<span class="text-muted small"></span></label>
                                <input type="checkbox" name="stripe_status" data-toggle="switchbutton" data-width="100"
                                    data-on="Enabled" data-size="sm" data-off="Disabled" data-onstyle="success"
                                    data-offstyle="danger" {{ setting('stripe_status')? 'checked' :'unchecked' }}>
                            </div>
                            <div class="form-group">
                                <label class="form-group">@lang('payment.stripe.key')</label>
                                <input type="hidden" name="types[]" value="STRIPE_KEY">
                                <input type="hidden" name="types[]" value="STRIPE_SECRET">
                                <input type="text" name="STRIPE_KEY" class="form-control"
                                    value="{{setting('stripe_key')}}" placeholder="@lang('plan.stripe_pub_key')">
                                <label class="form-group mt-2">@lang('payment.stripe.secret')</label>
                                <input type="text" name="STRIPE_SECRET" class="form-control"
                                    value="{{setting('stripe_secret')}}" placeholder="@lang('plan.stripe_sec_key')">
                            </div>
                            <div class="form-group">
                                <label for="name">@lang('payment.stripe.sandbox')<span class="text-muted small"></span></label>
                                <input type="checkbox" name="stripe_sandbox" data-toggle="switchbutton" data-width="100"
                                    data-on="Enabled" data-size="sm" data-off="Disabled" data-onstyle="success"
                                    data-offstyle="danger" {{ setting('stripe_sandbox')? 'checked' :'unchecked' }}>
                            </div>
                        </div>
                        <input type="submit" class="w-100 mt-2 btn btn-success" value="@lang('payment.stripe.update')">
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-6 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h4>@lang('payment.paypal.credentials')</h4>
                </div>
                <div class="card-body">
                    <form action="{{route('admin.settings.payment.paypal')}}" method="POST">
                        @csrf
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="name">@lang('payment.paypal.status')<span class="text-muted small"></span></label>
                                <input type="checkbox" name="paypal_status" data-toggle="switchbutton" data-width="100"
                                    data-on="Enabled" data-size="sm" data-off="Disabled" data-onstyle="success"
                                    data-offstyle="danger" {{ setting('paypal_status')? 'checked' :'unchecked' }}>
                            </div>
                            <div class="form-group">
                                <label class="form-group">@lang('payment.paypal.key')</label>
                                <input type="hidden" name="types[]" value="PAYPAL_CLIENT_ID">
                                <input type="hidden" name="types[]" value="PAYPAL_CLIENT_SECRET">
                                <input type="text" name="PAYPAL_CLIENT_ID" class="form-control"
                                    value="{{setting('paypal_client_id')}}"
                                    placeholder="@lang('payment.paypal.key')">
                                <label class="form-group mt-2">@lang('payment.paypal.secret')</label>
                                <input type="text" name="PAYPAL_CLIENT_SECRET" class="form-control"
                                    value="{{setting('paypal_client_secret')}}"
                                    placeholder="@lang('payment.paypal.secret')">
                            </div>
                            <div class="form-group">
                                <label for="name">@lang('payment.paypal.sandbox')<span class="text-muted small"></span></label>
                                <input type="checkbox" name="paypal_sandbox" data-toggle="switchbutton" data-width="100"
                                    data-on="Enabled" data-size="sm" data-off="Disabled" data-onstyle="success"
                                    data-offstyle="danger" {{ setting('paypal_sandbox')? 'checked' :'unchecked' }}>
                            </div>
                        </div>
                        <input type="submit" class="w-100 mt-2 btn btn-success" value="@lang('payment.paypal.update')">
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-6 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h4>@lang('payment.bkash.credentials')</h4>
                </div>
                <div class="card-body">
                    <form action="{{route('admin.settings.payment.bkash')}}" method="POST">
                        @csrf
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="name">@lang('payment.bkash.status')<span class="text-muted small"></span></label>
                                <input type="checkbox" name="bkash_status" data-toggle="switchbutton" data-width="100"
                                    data-on="Enabled" data-size="sm" data-off="Disabled" data-onstyle="success"
                                    data-offstyle="danger" {{ setting('bkash_status')? 'checked' :'unchecked' }}>
                            </div>
                            <div class="form-group">
                                <label class="form-group">@lang('payment.bkash.key')</label>

                                <input type="hidden" name="types[]" value="BKASH_CHECKOUT_APP_KEY">
                                <input type="hidden" name="types[]" value="BKASH_CHECKOUT_APP_SECRET">
                                <input type="hidden" name="types[]" value="BKASH_CHECKOUT_USER_NAME">
                                <input type="hidden" name="types[]" value="BKASH_CHECKOUT_PASSWORD">

                                <input type="text" name="BKASH_CHECKOUT_APP_KEY" class="form-control"
                                    value="{{setting('bkash_app_key')}}" placeholder="@lang('payment.bkash.key')">

                                <label class="form-group mt-2">@lang('payment.bkash.secret')</label>
                                <input type="text" name="BKASH_CHECKOUT_APP_SECRET" class="form-control"
                                    value="{{setting('bkash_app_secret')}}"
                                    placeholder="@lang('payment.bkash.secret')">

                                <label class="form-group mt-2">@lang('payment.bkash.username')</label>
                                <input type="text" name="BKASH_CHECKOUT_USER_NAME" class="form-control"
                                    value="{{setting('bkash_app_username')}}"
                                    placeholder="@lang('payment.bkash.username')">

                                <label class="form-group mt-2">@lang('payment.bkash.password')</label>
                                <input type="text" name="BKASH_CHECKOUT_PASSWORD" class="form-control"
                                    value="{{setting('bkash_app_password')}}"
                                    placeholder="@lang('payment.bkash.password')">
                            </div>
                            <div class="form-group">
                                <label for="name">@lang('payment.bkash.sandbox')<span class="text-muted small"></span></label>
                                <input type="checkbox" name="bkash_sandbox" data-toggle="switchbutton" data-width="100"
                                    data-on="Enabled" data-size="sm" data-off="Disabled" data-onstyle="success"
                                    data-offstyle="danger" {{ setting('bkash_sandbox')? 'checked' :'unchecked' }}>
                            </div>
                        </div>
                        <input type="submit" class="w-100 mt-2 btn btn-success" value="@lang('payment.bkash.update')">
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-6 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h4>@lang('payment.nagad.credentials')</h4>
                </div>
                <div class="card-body">
                    <form action="{{route('admin.settings.payment.nagad')}}" method="POST">
                        @csrf
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="name">@lang('payment.nagad.status')<span class="text-muted small"></span></label>
                                <input type="checkbox" name="nagad_status" data-toggle="switchbutton" data-width="100"
                                    data-on="Enabled" data-size="sm" data-off="Disabled" data-onstyle="success"
                                    data-offstyle="danger" {{ setting('nagad_status')? 'checked' :'unchecked' }}>
                            </div>
                            <div class="form-group">

                                <input type="hidden" name="types[]" value="NAGAD_MERCHANT_ID">
                                <input type="hidden" name="types[]" value="NAGAD_MERCHANT_NUMBER">
                                <input type="hidden" name="types[]" value="NAGAD_PG_PUBLIC_KEY">
                                <input type="hidden" name="types[]" value="NAGAD_MERCHANT_PRIVATE_KEY">

                                <label class="form-group">@lang('payment.nagad.merchant_id')</label>
                                <input type="text" name="NAGAD_MERCHANT_ID" class="form-control"
                                    value="{{setting('nagad_merchant_id')}}"
                                    placeholder="@lang('payment.nagad.merchant_id')">

                                <label class="form-group mt-2">@lang('payment.nagad.merchant_number')</label>
                                <input type="text" name="NAGAD_MERCHANT_NUMBER" class="form-control"
                                    value="{{setting('nagad_merchant_number')}}"
                                    placeholder="@lang('payment.nagad.merchant_number')">

                                <label class="form-group mt-2">@lang('payment.nagad.public_key')</label>
                                <input type="text" name="NAGAD_PG_PUBLIC_KEY" class="form-control"
                                    value="{{setting('nagad_public_key')}}"
                                    placeholder="@lang('payment.nagad.public_key')">

                                <label class="form-group mt-2">@lang('payment.nagad.private_key')</label>
                                <input type="text" name="NAGAD_MERCHANT_PRIVATE_KEY" class="form-control"
                                    value="{{setting('nagad_private_key')}}"
                                    placeholder="@lang('payment.nagad.private_key')">
                            </div>
                            <div class="form-group">
                                <label for="name">@lang('payment.nagad.sandbox')<span class="text-muted small"></span></label>
                                <input type="checkbox" name="nagad_sandbox" data-toggle="switchbutton" data-width="100"
                                    data-on="Enabled" data-size="sm" data-off="Disabled" data-onstyle="success"
                                    data-offstyle="danger" {{ setting('nagad_sandbox')? 'checked' :'unchecked' }}>
                            </div>
                        </div>
                        <input type="submit" class="w-100 mt-2 btn btn-success" value="@lang('payment.nagad.update')">
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
